﻿using Microsoft.Office.Interop.Word;
using System;

namespace WordAutomation
{
    class Program
    {
        static void Main(string[] args)
        {
            Application wordApp = new Application();

            OldStyle(wordApp);
            NewStyle(wordApp);
        }

        private static void NewStyle(Application wordApp)
        {
            wordApp.ChangeFileOpenDirectory(Environment.CurrentDirectory);

            // Listing 18-2. Automatyzacja programu Word zgodna z intencjami firmy Microsoft
            var doc = wordApp.Documents.Open("WordFile.docx", ReadOnly: true);


            ((_Document) doc).Close(SaveChanges: false);
        }

        private static void OldStyle(Application wordApp)
        {
            wordApp.ChangeFileOpenDirectory(Environment.CurrentDirectory);

            // Listing 18-3. Automatyzacja programu Word przed pojawieniem się języka C# 4.0
            object fileName = @"WordFile.docx";
            object missing = System.Reflection.Missing.Value;
            object readOnly = true;
            var doc = wordApp.Documents.Open(ref fileName, ref missing, ref readOnly,
                ref missing, ref missing, ref missing, ref missing, ref missing,
                ref missing, ref missing, ref missing, ref missing, ref missing,
                ref missing, ref missing, ref missing);


            ((_Document) doc).Close(false, ref missing, ref missing);
        }

    }
}
